;Live2D 3.x Sample Game
*start

; Load the Live2D plugin
[plugin name="live2d"]

[cm  ]
[clearfix]
[start_keyconfig]

; Show background
[bg storage="room.jpg" time="100"]

; Load message theme
[plugin name="theme_kopanda_07"]
[add_theme_button]

; Show message window
@layopt layer=message0 visible=true

; Declare characters used in this game
; akane
[chara_new  name="akane" storage="chara/akane/normal.png" jname="Akane"  ]
; Register facial expressions
[chara_face name="akane" face="angry" storage="chara/akane/angry.png"]
[chara_face name="akane" face="doki" storage="chara/akane/doki.png"]
[chara_face name="akane" face="happy" storage="chara/akane/happy.png"]
[chara_face name="akane" face="sad" storage="chara/akane/sad.png"]

; yamato
[chara_new name="yamato" storage="chara/yamato/normal.png" jname="Yamato" ]

This is a sample to demonstrate how the Live2D plugin works.[p]
Live2D 4.0 requires TyranoScript version 5 or later.[p]

; Load Live2D models
Loading Live2D models...
[live2d_new name="haru" model_id="Haru" lip=true jname="Haru"]
[live2d_new name="hiyori" model_id="Hiyori" y=-0.5 x=-0.3 lip=true jname="Hiyori"]
[wait time=200]

; Show Live2D model
[live2d_show name="haru" y=-0.8 x=0 scale=2.5 ]

[wait time=400]

The Live2D model has appeared.[p]

Now we’ll play a motion.[p]

Motion playback #1[p]
[live2d_motion name="haru" mtn="Test" no=0 ]
[wait time=3000 ]

Motion playback #2[p]
[live2d_motion name="haru" mtn="Test" no=1 ]
[wait time=3000 ]

How was that? The motion played, right?[p]

Now let’s change the expression (Expression)[p]

[live2d_expression name="haru" expression="f07"]

It’s changed.[p]

Next, we’ll change the idle motion of the character[p]
[live2d_mod name="haru" idle="Test" ]

Changed successfully.[p]
Now reverting the idle motion back to original[p]
[live2d_mod name="haru" idle="Idle" ]

We’ll now change the position. Moving to the left.[p]
[live2d_mod name="haru" x="-0.5" ]
Now moving to the right[p]
[live2d_mod name="haru" x="0.5" ]

Now let’s use fade-in and fade-out together.[p]

[live2d_fadeout time=1000 ]
[live2d_mod name="haru" y=-1.6 x="0" scale=3.5 ]

[live2d_fadein time=1000 ]

Zoomed in and shown. Now returning to original position[p]

[live2d_fadeout time=1000]
[live2d_mod name="haru" y="-0.8" x="0" scale=2.5 ]
[live2d_fadein time=1000]

How was that? Now we’ll show another model.[p]

[live2d_mod name="haru" x=-0.3]
[live2d_show name="hiyori" y=-0.8 x=0.3 scale=2.5 ]

Hiyori has appeared.[p]

Let’s test the mouth (lip) movement[p]
You can sync mouth movement with Tyrano syntax.[p]

#Haru
Right now Haru is talking.[p]
Is the lip movement smooth?[p]

#Hiyori
I'm Hiyori! I love Tyrano![p]
Aaaaaaaaaaaaaaaaaaaaaa[p]

#Yamato
T-This is scary…[p]

[live2d_fadeout]
[live2d_hide name="haru"] 
[live2d_hide name="hiyori"] 

Now loading a Live2D 4.0 model.[p]

[live2d_new name="rice" model_id="rice_pro_t01" jname="Rice"]
[wait time=200]

; Show Live2D model
[live2d_show name="rice" y=-0.8 x=0 scale=2.5 ]

[live2d_fadein]

#Rice

Playing motion #1[p]
[live2d_motion name="rice" mtn="TapBody" no=0]
Done.[p]

Playing motion #2[p]
[live2d_motion name="rice" mtn="TapBody" no=1]
Done.[p]

Playing motion #3[p]
[live2d_motion name="rice" mtn="TapBody" no=2]
Done.[p]



To use the Live2D plugin, you must agree to the Live2D licensing terms.[p]
Also, the bundled models belong to Live2D Inc., so please check the Live2D license carefully.[p]
Theme used: “Kūsō Kyokusen” (Imaginary Curve) - Theme Conversion Plugin No.7[p]
If you have questions or want to request additional features, feel free to reach out.[p]
You can download the full script of this game project—please use it as reference.

[s]
